/*global define, require */
/*jslint white: true */

/*
	curve utils:

	This file implements curve related utilities.
*/

define	([	"src/math/Vec2",	"src/math/curveUtils",	"src/math/curveFitUtils",	"src/math/curveAdaptEval",
			"src/math/TimeGraph"],
function(	V2,					curveUtils,				curveFitUtils,				curveAdaptEval,
			TimeGraph) {
	'use strict';

	function calculateDistanceAndPoints(inCurve, inStartDistance, inErrorTolerance, inCurveIndex, outDistPts) {
		var tValues = [], i, d = 0, dTotal = 0, t, prevPt, pt;

		inCurveIndex = inCurveIndex || 0;
		inStartDistance = inStartDistance || 0.0;
		inErrorTolerance = inErrorTolerance || 1e-3;

		if (outDistPts !== undefined) {
			outDistPts.push([inStartDistance, inCurveIndex]);
		}
		curveAdaptEval.evaluateCurveAdaptively(inCurve, curveAdaptEval.linearCurveAdaptEvaluator(tValues, undefined, inErrorTolerance));

		if (tValues.length > 0) {
			prevPt = curveUtils.evaluate2DCurve(inCurve, tValues[0]);

			for (i = 1; i < tValues.length; i += 1) {
				t = tValues[i];
				pt = curveUtils.evaluate2DCurve(inCurve, t);
				d = V2.distance(prevPt, pt);
				prevPt = pt;
				dTotal += d;
				if (outDistPts !== undefined) {
					outDistPts.push([dTotal + inStartDistance, t + inCurveIndex]);
				}
			}
		} else {
			if (outDistPts !== undefined) {
				outDistPts.push([inStartDistance, 1 + inCurveIndex]);
			}
		}

		return dTotal + inStartDistance;
	}

	function calculateDistance(inCurve, inErrorTolerance) {
		return calculateDistanceAndPoints(inCurve, undefined, inErrorTolerance);
	}

	function calculate(inCurve, inTimeGraph, inErrorTolerance) {
		var distPts = [], dCurves, curveIndex, startDistance;

		if (inTimeGraph !== undefined) {
			curveIndex = inTimeGraph.getYMax();
			startDistance = inTimeGraph.getXMax();
		}

		calculateDistanceAndPoints(inCurve, startDistance, inErrorTolerance, curveIndex, distPts);

		dCurves = curveFitUtils.fitCurvesToPoints(distPts, 1e-2, 12, true);

		if (inTimeGraph === undefined) {
			inTimeGraph = new TimeGraph(dCurves);
		} else {
			inTimeGraph.appendCurves(dCurves);
		}

		return inTimeGraph;
	}

	function calculateDistanceTimeGraph(inCurve, inTimeGraph, inErrorTolerance) {
		var	i;
		for (i = 0; i < inCurve.length; i += 1) {
			inTimeGraph = calculate(inCurve[i], inTimeGraph, inErrorTolerance);
		}
		return inTimeGraph;
	}

	return {
		// Fit a curve to an array of points.
		calculateDistance : calculateDistance,
		calculateDistanceTimeGraph : calculateDistanceTimeGraph
	};
});
